package jp.mosp.workflow.action;

import java.util.Date;

import jp.mosp.common.CommonConst;
import jp.mosp.common.action.MosPWorkflowAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dto.CtWorkflowDto;
import jp.mosp.common.part.DatePart;
import jp.mosp.common.part.KintaiApprovalPart;
import jp.mosp.common.part.StringPart;
import jp.mosp.common.part.WorkflowPart;

import jp.mosp.workflow.dto.CtOvertimeRequestDto;
import jp.mosp.workflow.vo.OverTimeRequestCardVo;

public class OverTimeRequestCardAction extends MosPWorkflowAction {

	// R}h
	private static final String CMD_CARD_SHOW 	= "K1415";
	private static final String CMD_CARD_SELECT 	= "K1416";
	private static final String CMD_CARD_INSERT 	= "K1417";
	private static final String CMD_CARD_UPDATE 	= "K1418";
	private static final String CMD_CARD_CANCEL 	= "K1419";

	/**
	 * RXgN^
	 */
	public OverTimeRequestCardAction() {
		super();
	}

	public void action() throws Exception {
		// VȌ
		OverTimeRequestCardVo vo = new OverTimeRequestCardVo(cfg, msg, nam, cmd, aspUser, user);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		vo.setParams(request);
		// DTO̎擾
		CtOvertimeRequestDto dto;
		Object obj = session.getAttribute(MospConst.ATT_DTO);
		dto = obj instanceof CtOvertimeRequestDto ? (CtOvertimeRequestDto)obj : null;
		// [U̎擾
		getInfo(user.getUserId());
		// \ڂ̐ݒ
		setLabelInfo(vo);
		// v_ẼZbg
		setPulldownList(vo);
		// R}h̏
		if (cmd.equals(CMD_CARD_SHOW)) {
			// l̐ݒ
			vo.setDefaultValues();
			Date todayDate = DatePart.getSystemDate();
			vo.setPltRequestYear(String.valueOf(MospUtility.getYear(todayDate)));
			vo.setPltRequestMonth(String.valueOf(MospUtility.getMonth(todayDate)));
			vo.setPltRequestDay(String.valueOf(MospUtility.getDay(todayDate)));
			// [hݒ
			vo.setMode(OverTimeRequestCardVo.MODE_INSERT);
		} else if (cmd.equals(CMD_CARD_SELECT)) {
			// \(L[ŏ)
			// f[^̎擾
			dto = getOverTimeRequest(vo.getIntParam(key1));
			chkExist(dto);
			// VOɏZbg
			vo.setFields(dto);
			// F󋵂̐ݒ
			setApprovalStatus(vo, dto);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_CARD_INSERT)) {
			// VKo^
			dto = insert(vo);
			// F󋵂̐ݒ
			setApprovalStatus(vo, dto);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_CARD_UPDATE)) {
			// XV
			dto = update(vo, dto);
			// F󋵂̐ݒ
			setApprovalStatus(vo, dto);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_CARD_CANCEL)) {
			// 艺
			cancel(vo, dto);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * \ڂ̐ݒ
	 * @param vo			ΏVO
	 * @throws Exception
	 */
	private void setLabelInfo(OverTimeRequestCardVo vo) throws Exception {
		vo.setLblKCode(mKihon.getKCode());
		vo.setLblKName(mKihon.getSimei());
		vo.setLblSection(getSectionName(mKihon.getSCode()));
	}

	/**
	 * v_E̐ݒ
	 * @param vo			ΏVO
	 * @throws Exception
	 */
	private void setPulldownList(OverTimeRequestCardVo vo) throws Exception {
		vo.aryPltYear = StringPart.getYearArray(MospUtility.getYear(DatePart.getSystemDate()));
		vo.aryPltMonth = StringPart.getMonthArray();
		vo.aryPltDay = StringPart.getDayArray();
		vo.aryPltHour = StringPart.getCountArray(0, 24, 1);
		// ͒PʎԐݒ
		setInputUnit();
		vo.aryPltMin = StringPart.getCountArray(0, 59, inputUnit);
	}

	/**
	 * VKo^
	 * @param vo	ΏVO
	 * @return 		f[^}ΏDTO
	 * @throws Exception
	 */
	private CtOvertimeRequestDto insert(OverTimeRequestCardVo vo) throws Exception {
		// p[^[̑ÓmF
		vo.validate();
		// DTȌ
		CtOvertimeRequestDto dto = new CtOvertimeRequestDto();
		vo.setDtoFields(dto);
		dto.setKCode(mKihon.getKCode());
		dto.setRequestDate(DatePart.getSystemDate());
		// dmF
		chkDuplicate(getTargetOverTimeRequest(dto.getKCode(), dto.getWorkDate()), vo);
		// e[ubN
		prepareTableLock();
		// Ώۃe[uǉ
		addTargetTable(overRequestDao(), true);
		// [Nt[o^
		long workflow = requestRegist(mKihon.getKCode(), WorkflowPart.isDraft(key1));
		if (workflow != 0) {
			dto.setWorkflow(workflow);
			// cƐ\
			String maxVaoucher = overRequestDao().findForMax();
			if (maxVaoucher == null || maxVaoucher.equals("")) {
				maxVaoucher = "-1";
			} else {
				overRequestDao().findForUpdate(Integer.parseInt(maxVaoucher));
			}
			// őlZbg
			dto.setVoucher(Integer.parseInt(maxVaoucher) + 1);
			overRequestDao().insert(dto);
			chkInsert(getOverTimeRequest(dto.getVoucher()));
			//R~bg
			commit();
			// DTO̍Ď擾
			dto = getOverTimeRequest(dto.getVoucher());
			vo.setHidVoucher(String.valueOf(dto.getVoucher()));
			// bZ[Wݒ
			vo.setMessage(MospUtility.getMessage(msg, CommonConst.MSG_CODE_REQUEST_INSERT, ""));
		} else {
			StringBuffer sb = new StringBuffer();
			sb.append(DatePart.convDateToFormatDateJP(dto.getWorkDate()));
			sb.append(CommonConst.MSG_OF);
			sb.append(CommonConst.NAM_OVER_TIME_REQUEST);
			// G[bZ[Wݒ
			vo.addErrMessage(MospUtility.getMessage(msg,
					CommonConst.MSG_CODE_SELECT_CANNOT_INSERT,
					sb.toString()
			));
		}
		// e[ubN
		unLockTables();
		// DTO̕\
		vo.setFields(dto);
		return dto;
	}

	/**
	 * XV
	 * @param vo			ΏVO
	 * @param dto			ΏDTO
	 * @return
	 * @throws Exception
	 */
	private CtOvertimeRequestDto update(OverTimeRequestCardVo vo, CtOvertimeRequestDto dto) throws Exception {
		vo.setPltRequestYear(String.valueOf(MospUtility.getYear(dto.getWorkDate())));
		vo.setPltRequestMonth(String.valueOf(MospUtility.getMonth(dto.getWorkDate())));
		vo.setPltRequestDay(String.valueOf(MospUtility.getDay(dto.getWorkDate())));
		// p[^[̑ÓmF
		vo.validate();
		// DTȌ
		vo.setDtoFields(dto);
		dto.setKCode(mKihon.getKCode());
		dto.setRequestDate(DatePart.getSystemDate());
		// rmF
		chkExclusive(dto, overRequestDao().findForUpdate(dto.getVoucher()), vo);
		// XV
		overRequestDao().update(dto);
		// XVmF
		chkUpdate(getOverTimeRequest(dto.getVoucher()));
		boolean canCommit = true;
		// \XV̏ꍇ
		if (!WorkflowPart.isDraft(key1)) {
			// [Nt[擾
			CtWorkflowDto workflowDto = getWorkflowDto(dto.getWorkflow());
			// F󋵂̕ύX
			workflowDto.setCurrentStatus(WorkflowPart.getStatusCodeArray()[0]);
			// ΑӏFR[h
			String statusCode = toKintaiApprovalStatus(dto.getWorkflow());
			// ߁\̏ꍇ
			if (KintaiApprovalPart.is1stReturned(statusCode)
					|| KintaiApprovalPart.is2ndReturned(statusCode)
			) {
				// \ֈڍs
				workflowDto.setLayerNumber(0);
			}
			// [Nt[̍XV
			canCommit = workflowRegist(workflowDto, vo);
		}
		if (canCommit) {
			// R~bg
			commit();
			// bZ[Wݒ
			vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		}
		// DTO̍Ď擾
		CtOvertimeRequestDto retDto = getOverTimeRequest(dto.getVoucher());
		chkExist(retDto);
		return retDto;
	}

	/**
	 * 艺
	 * @param vo		ΏVO
	 * @throws Exception
	 */
	private void cancel(OverTimeRequestCardVo vo, CtOvertimeRequestDto dto) throws Exception {
		// Fς݂̏ꍇA艺s
		if (!isStatusApproved(dto.getWorkflow())) {
			// _폜
			dto.setDeleteFlag(MospConst.DELETE_FLAG_ON);
			overRequestDao().update(dto);
			// [Nt[
			CtWorkflowDto workflowDto = getWorkflowDto(dto.getWorkflow());
			// _폜
			workflowDto.setDeleteFlag(MospConst.DELETE_FLAG_ON);
			workflowRegist(workflowDto, vo);
			// R~bg
			commit();
			// ꗗ֑J
			setNextCmd(OverTimeRequestListAction.CMD_LIST_RE_SEARCH);
			// bZ[WZbg
			request.setAttribute(MospConst.ATT_MESSAGE, MospUtility.getMessage(msg,
					CommonConst.MSG_CODE_REQUEST_WITHDRAW,
					""
			));
		} else {
			StringBuffer sb = new StringBuffer();
			sb.append(DatePart.convDateToFormatDateJP(dto.getWorkDate()));
			sb.append(CommonConst.MSG_OF);
			sb.append(CommonConst.NAM_OVER_TIME_REQUEST);
			// G[bZ[W
			vo.addErrMessage(MospUtility.getMessage(msg,
					CommonConst.MSG_CODE_SELECT_ALREADY_APPROVED,
					sb.toString()
			));
		}
	}

	/**
	 * F󋵏̐ݒ
	 * @param vo			ΏVO
	 * @param dto			ΏDTO
	 * @throws Exception
	 */
	private void setApprovalStatus(
			OverTimeRequestCardVo vo,
			CtOvertimeRequestDto dto
	) throws Exception {
		// ΑӏFXe[^XR[h
		String statusCode = toKintaiApprovalStatus(dto.getWorkflow());
		vo.setLblStatus(getApprovalName(statusCode));
		// 
		if (isStatusDraft(dto.getWorkflow())) {
			vo.setMode(OverTimeRequestCardVo.MODE_UPDATE);
		}
		// \
		else if (KintaiApprovalPart.isRequest(statusCode)) {
			vo.setMode(OverTimeRequestCardVo.MODE_REQUEST);
		}
		// ꎟF
		else if (KintaiApprovalPart.is1stApproved(statusCode)) {
			vo.setLblApprover(getKName(getWorkflowDto(dto.getWorkflow()).getUpdateUser()));
			vo.setMode(OverTimeRequestCardVo.MODE_APPROVED);
		}
		// ꎟ
		else if (KintaiApprovalPart.is1stReturned(statusCode)) {
			vo.setLblApprover(getKName(getWorkflowDto(dto.getWorkflow()).getUpdateUser()));
			// ŐVRg̎擾
			vo.setLblComment(getCurrentWorkflowComment(mKihon.getKCode(), dto.getWorkflow()));
			vo.setMode(OverTimeRequestCardVo.MODE_RETURNED);
		}
		// 񎟏F
		else if (KintaiApprovalPart.is2ndApproved(statusCode)) {
			vo.setLblApprover(getKName(getWorkflowDto(dto.getWorkflow()).getUpdateUser()));
			vo.setMode(OverTimeRequestCardVo.MODE_APPROVED);
		}
		// 񎟍
		else if (KintaiApprovalPart.is2ndReturned(statusCode)) {
			vo.setLblApprover(getKName(getWorkflowDto(dto.getWorkflow()).getUpdateUser()));
			// ŐVRg̎擾
			vo.setLblComment(getCurrentWorkflowComment(mKihon.getKCode(), dto.getWorkflow()));
			vo.setMode(OverTimeRequestCardVo.MODE_RETURNED);
		}
	}

}
